/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.ErrorDialog;
import com.rameses.osiris3.platform.ModuleEntry;
import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPlatformLoader;
import com.rameses.osiris3.platform.UpdateCenter;
import java.util.Map;
import javax.swing.UIManager;

public final class OSBootStrap {
    public static void main(String[] args) throws Exception {
        try {
            String plaf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(plaf);
        }
        catch (Throwable plaf) {
            // empty catch block
        }
        OSBootStrap bootstrap = new OSBootStrap();
        bootstrap.showStartup();
        bootstrap.startUpdates();
    }

    private OSBootStrap() {
    }

    private void showStartup() {
        try {
            OSManager osm = OSManager.getInstance();
            osm.init();
            osm.getStartupWindow().setVisible(true);
        }
        catch (Throwable t) {
            ErrorDialog.show(t);
            this.terminate();
        }
    }

    private void startUpdates() {
        try {
            UpdateCenterHandler handler = new UpdateCenterHandler();
            OSPlatformLoader.DownloadResult result = OSPlatformLoader.downloadUpdates(handler);
            Map env = result.getEnv();
            this.prepareLookAndFeel(env);
            OSManager osm = OSManager.getInstance();
            osm.setAppLoader(result.deriveAppLoader());
            osm.getMainWindow().show();
        }
        catch (Throwable t) {
            ErrorDialog.show(t);
            this.terminate();
        }
    }

    private void prepareLookAndFeel(Map env) {
        String[] arr = new String[]{(String)env.get("plaf"), System.getProperty("plaf"), System.getenv("plaf"), UIManager.getSystemLookAndFeelClassName()};
        String plaf = null;
        for (String str : arr) {
            if (str == null || str.trim().length() <= 0) continue;
            plaf = str;
            break;
        }
        boolean plaf_changed = false;
        try {
            if (plaf != null) {
                System.out.println("plaf ==> " + plaf);
                UIManager.setLookAndFeel(plaf);
                plaf_changed = true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (plaf_changed) {
            OSManager.getInstance().updateComponentTreeUI();
        }
    }

    private void terminate() {
        try {
            System.exit(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class UpdateCenterHandler
    implements UpdateCenter.Handler {
        private UpdateCenterHandler() {
        }

        @Override
        public void onmessage(String message) {
            OSManager.getInstance().getStartupWindow().setTextValue(message);
        }

        @Override
        public void ondownload(ModuleEntry me) {
            String msg = "Downloading " + me.getFilename() + "...";
            this.onmessage(msg);
        }

        @Override
        public void oncomplete() {
            this.onmessage("Initializing please wait...");
        }
    }
}

