/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BaseScrollBarUI
extends BasicScrollBarUI {
    protected int scrollBarWidth = 17;
    protected int incrGap = 0;
    protected int decrGap = 0;
    protected boolean isRollover = false;

    public static ComponentUI createUI(JComponent c) {
        return new BaseScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollBarWidth = UIManager.getInt("ScrollBar.width");
        this.incrGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        this.decrGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        String scaleKey = (String)this.scrollbar.getClientProperty("JComponent.sizeVariant");
        if (scaleKey != null) {
            if ("large".equals(scaleKey)) {
                this.scrollBarWidth = (int)((double)this.scrollBarWidth * 1.15);
                this.incrGap = (int)((double)this.incrGap * 1.15);
                this.decrGap = (int)((double)this.decrGap * 1.15);
            } else if ("small".equals(scaleKey)) {
                this.scrollBarWidth = (int)((double)this.scrollBarWidth * 0.857);
                this.incrGap = (int)((double)this.incrGap * 0.857);
                this.decrGap = (int)((double)this.decrGap * 0.857);
            } else if ("mini".equals(scaleKey)) {
                this.scrollBarWidth = (int)((double)this.scrollBarWidth * 0.714);
                this.incrGap = (int)((double)this.incrGap * 0.714);
                this.decrGap = (int)((double)this.decrGap * 0.714);
            }
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return new InvisibleScrollButton();
        }
        return new BaseScrollButton(orientation, this.scrollBarWidth);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return new InvisibleScrollButton();
        }
        return new BaseScrollButton(orientation, this.scrollBarWidth);
    }

    @Override
    public BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            if (this.scrollbar.getOrientation() == 1) {
                return new Dimension(this.scrollBarWidth + 1, this.scrollBarWidth * 3);
            }
            return new Dimension(this.scrollBarWidth * 3, this.scrollBarWidth);
        }
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 16);
        }
        return new Dimension(this.scrollBarWidth * 3 + 16, this.scrollBarWidth);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            Color bc = ColorHelper.darker(AbstractLookAndFeel.getTheme().getBackgroundColor(), 4.0);
            g.setColor(bc);
            g.fillRect(0, 0, w, h);
        } else if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g, AbstractLookAndFeel.getTheme().getTrackColors(), 0, 0, w, h);
        } else {
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getTrackColors(), 0, 0, w, h);
        }
    }

    protected Color[] getThumbColors() {
        if (this.isRollover || this.isDragging) {
            return AbstractLookAndFeel.getTheme().getRolloverColors();
        }
        if (!JTattooUtilities.isActive(this.scrollbar)) {
            return AbstractLookAndFeel.getTheme().getInActiveColors();
        }
        return AbstractLookAndFeel.getTheme().getThumbColors();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        Color[] colors = this.getThumbColors();
        Color frameColorHi = ColorHelper.brighter(colors[1], 20.0);
        Color frameColorLo = ColorHelper.darker(colors[colors.length - 1], 10.0);
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g, frameColorLo, ColorHelper.darker(frameColorLo, 15.0), 0, 0, thumbBounds.width, thumbBounds.height);
            g2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g.setColor(frameColorHi);
            g.drawLine(1, 1, thumbBounds.width - 2, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            if (!AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
                int dx = 5;
                int dy = thumbBounds.height / 2 - 3;
                int dw = thumbBounds.width - 11;
                Color c1 = Color.white;
                Color c2 = Color.darkGray;
                for (int i = 0; i < 4; ++i) {
                    g.setColor(c1);
                    g.drawLine(dx, dy, dx + dw, dy);
                    g.setColor(c2);
                    g.drawLine(dx, ++dy, dx + dw, dy);
                    ++dy;
                }
            }
            g2D.setComposite(savedComposite);
        } else {
            JTattooUtilities.fillHorGradient(g, colors, 1, 1, thumbBounds.width - 1, thumbBounds.height - 1);
            JTattooUtilities.draw3DBorder(g, frameColorLo, ColorHelper.darker(frameColorLo, 10.0), 0, 0, thumbBounds.width, thumbBounds.height);
            g2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
            g.setColor(frameColorHi);
            g.drawLine(1, 1, thumbBounds.width - 2, 1);
            g.drawLine(1, 1, 1, thumbBounds.height - 2);
            if (!AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
                int dx = thumbBounds.width / 2 - 3;
                int dy = 5;
                int dh = thumbBounds.height - 11;
                Color c1 = Color.white;
                Color c2 = Color.darkGray;
                for (int i = 0; i < 4; ++i) {
                    g.setColor(c1);
                    g.drawLine(dx, dy, dx, dy + dh);
                    g.setColor(c2);
                    g.drawLine(++dx, dy, dx, dy + dh);
                    ++dx;
                }
            }
        }
        g2D.setComposite(savedComposite);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        if (AbstractLookAndFeel.getTheme().isLinuxStyleScrollBarOn() && this.incrButton.isVisible() && this.decrButton.isVisible()) {
            Dimension sbSize = sb.getSize();
            Insets sbInsets = sb.getInsets();
            int sizeH = sbSize.height - sbInsets.top - sbInsets.bottom;
            int itemX = sbInsets.left;
            int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
            int itemH = Math.min(itemW, sizeH / 2);
            int decrButtonY = sbSize.height - sbInsets.bottom - itemH - itemH + 1;
            int incrButtonY = sbSize.height - sbInsets.bottom - itemH;
            float trackH = sbSize.height - sbInsets.top - sbInsets.bottom - itemW - itemW + 1;
            float min = sb.getMinimum();
            float max = sb.getMaximum();
            float extent = sb.getVisibleAmount();
            float range = max - min;
            float value = sb.getValue();
            int maxThumbH = this.getMaximumThumbSize().height;
            int minThumbH = this.getMinimumThumbSize().height;
            int thumbH = range <= 0.0f ? maxThumbH : (int)(trackH * (extent / range));
            thumbH = Math.max(thumbH, minThumbH);
            thumbH = Math.min(thumbH, maxThumbH);
            int thumbY = decrButtonY - thumbH;
            if (value < max - extent) {
                float thumbRange = trackH - (float)thumbH;
                thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            }
            if ((float)thumbH > trackH) {
                this.setThumbBounds(0, 0, 0, 0);
            } else {
                this.setThumbBounds(itemX, thumbY, itemW, thumbH);
            }
            this.decrButton.setBounds(itemX, decrButtonY, itemW, itemH);
            this.incrButton.setBounds(itemX, incrButtonY, itemW, itemH);
            this.trackRect.setBounds(itemX, 0, itemW, (int)trackH);
        } else {
            super.layoutVScrollbar(sb);
        }
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        if (AbstractLookAndFeel.getTheme().isLinuxStyleScrollBarOn() && this.incrButton.isVisible() && this.decrButton.isVisible()) {
            Dimension sbSize = sb.getSize();
            Insets sbInsets = sb.getInsets();
            int sizeW = sbSize.width - sbInsets.left - sbInsets.right;
            int itemY = sbInsets.top;
            int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
            int itemW = Math.min(itemH, sizeW / 2);
            int decrButtonX = sbSize.width - sbInsets.right - itemW - itemW + 1;
            int incrButtonX = sbSize.width - sbInsets.right - itemW;
            float trackW = sbSize.width - sbInsets.left - sbInsets.right - itemH - itemH + 1;
            float min = sb.getMinimum();
            float max = sb.getMaximum();
            float extent = sb.getVisibleAmount();
            float range = max - min;
            float value = sb.getValue();
            int maxThumbW = this.getMaximumThumbSize().width;
            int minThumbW = this.getMinimumThumbSize().width;
            int thumbW = range <= 0.0f ? maxThumbW : (int)(trackW * (extent / range));
            thumbW = Math.max(thumbW, minThumbW);
            thumbW = Math.min(thumbW, maxThumbW);
            int thumbX = decrButtonX - thumbW;
            if (value < max - extent) {
                float thumbRange = trackW - (float)thumbW;
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            }
            if ((float)thumbW > trackW) {
                this.setThumbBounds(0, 0, 0, 0);
            } else {
                this.setThumbBounds(thumbX, itemY, thumbW, itemH);
            }
            this.decrButton.setBounds(decrButtonX, itemY, itemW, itemH);
            this.incrButton.setBounds(incrButtonX, itemY, itemW, itemH);
            this.trackRect.setBounds(0, itemY, (int)trackW, itemH);
        } else {
            super.layoutHScrollbar(sb);
        }
    }

    private static class InvisibleScrollButton
    extends JButton {
        public InvisibleScrollButton() {
            this.setVisible(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(BaseScrollBarUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            BaseScrollBarUI.this.isRollover = true;
            Rectangle r = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            BaseScrollBarUI.this.isRollover = false;
            Rectangle r = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            Rectangle r = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            Rectangle r = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
        }
    }
}

