/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.custom.impl;

import com.rameses.common.PropertyResolver;
import com.rameses.util.BreakException;
import com.rameses.util.ValueUtil;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyResolverImpl
extends PropertyResolver {
    private String fixPropertyName(Object bean, String propertyName) {
        if (propertyName.indexOf("[") < 0) {
            return propertyName;
        }
        String[] arr = propertyName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            String x = arr[i];
            if (i > 0 && x.indexOf("[") > 0 && x.indexOf("(") < 0) {
                sb.append("(" + x.replace("[", ")["));
                continue;
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public boolean setProperty(Object bean, String propertyName, Object value) {
        boolean debug = "true".equals(System.getProperty("PropertyResolver.debug", "false"));
        try {
            PropertyUtils.setProperty((Object)bean, (String)this.fixPropertyName(bean, propertyName), (Object)value);
            return true;
        }
        catch (Exception ex) {
            if (debug) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public Class getPropertyType(Object bean, String propertyName) {
        try {
            return PropertyUtils.getPropertyType((Object)bean, (String)this.fixPropertyName(bean, propertyName));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getProperty(Object bean, String propertyName) {
        if (bean == null) {
            return null;
        }
        if (ValueUtil.isEmpty((Object)propertyName)) {
            return null;
        }
        boolean debug = "true".equals(System.getProperty("PropertyResolver.debug", "false"));
        String name = this.fixPropertyName(bean, propertyName);
        try {
            return PropertyUtils.getProperty((Object)bean, (String)name);
        }
        catch (BreakException be) {
            throw be;
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() != null) {
                if (ite.getTargetException() instanceof BreakException) {
                    throw (BreakException)ite.getTargetException();
                }
                System.out.println("[PropertyResolverImpl] " + ite.getTargetException().getMessage());
            }
            if (debug) {
                ite.printStackTrace();
            }
            return null;
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            if (e instanceof MissingPropertyException) {
                return null;
            }
            return null;
        }
    }
}

