/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

class LCDGraphicBitmapType {
    byte[] buffer;
    int bufferSize;
    int bytesWide;
    int xSizeNew;
    int xPosNew;
    int xOffset;
    static final int[] pixelMap = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    static final int LCD_1_Bit = 0;
    static final int LCD_2_Bit = 1;
    static final int LCD_4_Bit = 2;
    static final int LCD_8_Bit = 3;
    int pixelDepth = 0;
    int realXSize;
    int realYSize;

    boolean init(int xPos, int yPos, int xSize, int ySize) {
        return this.init(xPos, yPos, xSize, ySize, this.pixelDepth);
    }

    void setPixel(int x, int y) {
        this.setPixel(x, y, 0);
    }

    void dump() {
        System.out.println("LCDBmp: bufferSize = " + this.bufferSize);
        System.out.println("LCDBmp: bytesWide  = " + this.bytesWide);
        System.out.println("LCDBmp: xSizeNew   = " + this.xSizeNew);
        System.out.println("LCDBmp: xPosNew    = " + this.xPosNew);
        System.out.println("LCDBmp: xOffset    = " + this.xOffset);
    }

    boolean init(int xPos, int yPos, int xSize, int ySize, int pDepth) {
        this.pixelDepth = pDepth;
        switch (this.pixelDepth) {
            case 3: {
                int firstByte = xPos;
                int lastByte = xPos + xSize - 1;
                this.bytesWide = xSize;
                this.xSizeNew = xSize;
                this.xPosNew = firstByte;
                this.xOffset = 0;
                this.realXSize = this.xSizeNew;
                this.realYSize = ySize;
                break;
            }
            case 2: {
                int firstByte = xPos / 2;
                int lastByte = (xPos + xSize - 1) / 2;
                this.bytesWide = lastByte - firstByte + 1;
                this.xSizeNew = this.bytesWide * 2;
                this.xPosNew = firstByte * 2;
                this.xOffset = xPos % 2;
                this.realXSize = this.xSizeNew;
                this.realYSize = ySize;
                break;
            }
            case 1: {
                int firstByte = xPos / 4;
                int lastByte = (xPos + xSize - 1) / 4;
                this.bytesWide = lastByte - firstByte + 1;
                this.xSizeNew = this.bytesWide * 4;
                this.xPosNew = firstByte * 4;
                this.xOffset = xPos % 4;
                this.realXSize = this.xSizeNew;
                this.realYSize = ySize;
                break;
            }
            default: {
                int firstByte = xPos / 8;
                int lastByte = (xPos + xSize - 1) / 8;
                this.bytesWide = lastByte - firstByte + 1;
                this.xSizeNew = this.bytesWide * 8;
                this.xPosNew = firstByte * 8;
                this.xOffset = xPos % 8;
                this.realXSize = this.xSizeNew;
                this.realYSize = ySize;
            }
        }
        this.bufferSize = this.bytesWide * ySize;
        this.buffer = new byte[this.bufferSize];
        if (this.buffer != null) {
            int i = 0;
            while (i < this.bufferSize) {
                this.buffer[i] = 0;
                ++i;
            }
            return true;
        }
        return false;
    }

    public void setPixel(int x, int y, int v) {
        switch (this.pixelDepth) {
            case 3: {
                this.setPixel_8_Bit(x, y, v);
                break;
            }
            case 2: {
                this.setPixel_4_Bit(x, y, v);
                break;
            }
            case 1: {
                this.setPixel_2_Bit(x, y, v);
                break;
            }
            default: {
                this.setPixel_1_Bit(x, y, v);
            }
        }
    }

    public void setPixel_1_bit(int x, int y, int v) {
        if ((v & 0xFFFFFF) == 0xFFFFFF) {
            return;
        }
        if (this.buffer == null) {
            return;
        }
        if (x >= this.realXSize || x < 0) {
            return;
        }
        if (y >= this.realYSize || y < 0) {
            return;
        }
        int byteIdx = (x + this.xOffset) / 8 + y * this.bytesWide;
        int bitIdx = (x + this.xOffset) % 8;
        if (byteIdx < this.bufferSize) {
            int n = byteIdx;
            this.buffer[n] = (byte)(this.buffer[n] | (byte)pixelMap[bitIdx]);
        }
    }

    public void setPixel_1_Bit(int x, int y, int v) {
        if ((v & 0xFF0000) > 0x200000 || (v & 0xFF00) > 8192 || (v & 0xFF) > 32) {
            return;
        }
        if (this.buffer == null) {
            return;
        }
        if (x >= this.realXSize || x < 0) {
            return;
        }
        if (y >= this.realYSize || y < 0) {
            return;
        }
        int byteIdx = (x + this.xOffset) / 8 + y * this.bytesWide;
        int bitIdx = (x + this.xOffset) % 8;
        if (byteIdx < this.bufferSize) {
            int n = byteIdx;
            this.buffer[n] = (byte)(this.buffer[n] | (byte)pixelMap[bitIdx]);
        }
    }

    public void setPixel_2_Bit(int x, int y, int v) {
        int colorIdx;
        switch (v) {
            case 0: {
                colorIdx = 0;
                break;
            }
            case 0xFFFF00: {
                colorIdx = 1;
                break;
            }
            case 0xFF0000: {
                colorIdx = 2;
                break;
            }
            case 0xFFFFFF: {
                colorIdx = 3;
                break;
            }
            default: {
                colorIdx = 0;
            }
        }
        if (this.buffer == null) {
            return;
        }
        if (x >= this.realXSize || x < 0) {
            return;
        }
        if (y >= this.realYSize || y < 0) {
            return;
        }
        int byteIdx = (x + this.xOffset) / 4 + y * this.bytesWide;
        int bitIdx = (x + this.xOffset) % 4;
        if (byteIdx < this.bufferSize) {
            switch (bitIdx) {
                case 0: {
                    colorIdx <<= 6;
                    break;
                }
                case 1: {
                    colorIdx <<= 4;
                    break;
                }
                case 2: {
                    colorIdx <<= 2;
                    break;
                }
                case 3: {
                    break;
                }
            }
            int n = byteIdx;
            this.buffer[n] = (byte)(this.buffer[n] | colorIdx);
        }
    }

    public void setPixel_4_Bit(int x, int y, int v) {
        int colorIdx;
        switch (v) {
            case 0: {
                colorIdx = 0;
                break;
            }
            case 0x800000: {
                colorIdx = 1;
                break;
            }
            case 32768: {
                colorIdx = 2;
                break;
            }
            case 0x808000: {
                colorIdx = 3;
                break;
            }
            case 128: {
                colorIdx = 4;
                break;
            }
            case 0x800080: {
                colorIdx = 5;
                break;
            }
            case 32896: {
                colorIdx = 6;
                break;
            }
            case 0xC0C0C0: {
                colorIdx = 7;
                break;
            }
            case 0x808080: {
                colorIdx = 8;
                break;
            }
            case 0xFF0000: {
                colorIdx = 9;
                break;
            }
            case 65280: {
                colorIdx = 10;
                break;
            }
            case 0xFFFF00: {
                colorIdx = 11;
                break;
            }
            case 255: {
                colorIdx = 12;
                break;
            }
            case 0xFF00FF: {
                colorIdx = 13;
                break;
            }
            case 65535: {
                colorIdx = 14;
                break;
            }
            case 0xFFFFFF: {
                colorIdx = 15;
                break;
            }
            default: {
                colorIdx = 0;
            }
        }
        if (this.buffer == null) {
            return;
        }
        if (x >= this.realXSize || x < 0) {
            return;
        }
        if (y >= this.realYSize || y < 0) {
            return;
        }
        int byteIdx = (x + this.xOffset) / 2 + y * this.bytesWide;
        int bitIdx = (x + this.xOffset) % 2;
        if (byteIdx < this.bufferSize) {
            if (bitIdx != 1) {
                colorIdx <<= 4;
            }
            int n = byteIdx;
            this.buffer[n] = (byte)(this.buffer[n] | colorIdx);
        }
    }

    public void setPixel_8_Bit(int x, int y, int v) {
        if (this.buffer == null) {
            return;
        }
        if (x >= this.realXSize || x < 0) {
            return;
        }
        if (y >= this.realYSize || y < 0) {
            return;
        }
        if (v != 0) {
            boolean bl = false;
        }
        int newByte = (v & 0xC0) >> 6;
        newByte |= (v & 0xE000) >> 11;
        newByte |= (v & 0xE00000) >> 16;
        int byteIdx = x + y * this.bytesWide;
        if (byteIdx < this.bufferSize) {
            this.buffer[byteIdx] = (byte)newByte;
        }
    }
}

