/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import java.io.File;
import java.net.URL;

public class ModuleEntry {
    private String name;
    private double version = 0.0;
    private double size = 0.0;
    private String appPath;
    private String fileName;

    public ModuleEntry(String n, String v, String sz) {
        this.name = n;
        if (v != null) {
            this.version = Double.parseDouble(v);
        }
        if (sz != null) {
            this.size = Double.parseDouble(sz);
        }
        if (this.version == 0.0) {
            this.fileName = this.name;
        } else {
            String vr = (this.version + "").replaceAll("\\.", "_");
            this.fileName = this.name.substring(0, this.name.lastIndexOf(".")) + "-" + vr + ".jar";
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleEntry)) {
            return false;
        }
        return this.name.equals(((ModuleEntry)obj).getName());
    }

    public String getName() {
        return this.name;
    }

    public String getModulePath() {
        return this.appPath;
    }

    public void setModulePath(String appPath) {
        this.appPath = appPath;
    }

    public URL getURL() throws Exception {
        File f = new File(this.appPath + this.getFilename());
        return f.toURL();
    }

    public String getFilename() {
        return this.fileName;
    }
}

