/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.AbstractBorderFactory;
import com.jtattoo.plaf.AbstractIconFactory;
import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.AbstractTheme;
import com.jtattoo.plaf.BaseCheckBoxMenuItemUI;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.BaseEditorPaneUI;
import com.jtattoo.plaf.BaseFileChooserUI;
import com.jtattoo.plaf.BaseFormattedTextFieldUI;
import com.jtattoo.plaf.BaseLabelUI;
import com.jtattoo.plaf.BaseMenuItemUI;
import com.jtattoo.plaf.BaseMenuUI;
import com.jtattoo.plaf.BasePasswordFieldUI;
import com.jtattoo.plaf.BasePopupMenuUI;
import com.jtattoo.plaf.BaseProgressBarUI;
import com.jtattoo.plaf.BaseRadioButtonMenuItemUI;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.BaseSeparatorUI;
import com.jtattoo.plaf.BaseSpinnerUI;
import com.jtattoo.plaf.BaseTableHeaderUI;
import com.jtattoo.plaf.BaseTableUI;
import com.jtattoo.plaf.BaseTextAreaUI;
import com.jtattoo.plaf.BaseTextFieldUI;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.BaseToolTipUI;
import com.jtattoo.plaf.BaseTreeUI;
import com.jtattoo.plaf.bernstein.BernsteinBorderFactory;
import com.jtattoo.plaf.bernstein.BernsteinButtonUI;
import com.jtattoo.plaf.bernstein.BernsteinCheckBoxUI;
import com.jtattoo.plaf.bernstein.BernsteinDefaultTheme;
import com.jtattoo.plaf.bernstein.BernsteinDesktopPaneUI;
import com.jtattoo.plaf.bernstein.BernsteinIconFactory;
import com.jtattoo.plaf.bernstein.BernsteinInternalFrameUI;
import com.jtattoo.plaf.bernstein.BernsteinMenuBarUI;
import com.jtattoo.plaf.bernstein.BernsteinPanelUI;
import com.jtattoo.plaf.bernstein.BernsteinRadioButtonUI;
import com.jtattoo.plaf.bernstein.BernsteinRootPaneUI;
import com.jtattoo.plaf.bernstein.BernsteinScrollPaneUI;
import com.jtattoo.plaf.bernstein.BernsteinSliderUI;
import com.jtattoo.plaf.bernstein.BernsteinSplitPaneUI;
import com.jtattoo.plaf.bernstein.BernsteinTabbedPaneUI;
import com.jtattoo.plaf.bernstein.BernsteinToolBarUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;

public class BernsteinLookAndFeel
extends AbstractLookAndFeel {
    private static BernsteinDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        BernsteinLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(String name, String licenseKey, String logoString) {
        Properties props = (Properties)themesMap.get(name);
        if (props != null) {
            props.put("licenseKey", licenseKey);
            props.put("logoString", logoString);
            BernsteinLookAndFeel.setTheme(props);
            if (myTheme != null) {
                AbstractTheme.setInternalName(name);
            }
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "bernsteinTheme";
        if (myTheme == null) {
            myTheme = new BernsteinDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        BernsteinLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "Bernstein";
    }

    @Override
    public String getID() {
        return "Bernstein";
    }

    @Override
    public String getDescription() {
        return "The Bernstein Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return BernsteinBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return BernsteinIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new BernsteinDefaultTheme();
        }
        BernsteinLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"bernsteinTheme".equals(currentThemeName)) {
            BernsteinLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"ToggleButtonUI", BaseToggleButtonUI.class.getName(), "LabelUI", BaseLabelUI.class.getName(), "SeparatorUI", BaseSeparatorUI.class.getName(), "TextFieldUI", BaseTextFieldUI.class.getName(), "TextAreaUI", BaseTextAreaUI.class.getName(), "EditorPaneUI", BaseEditorPaneUI.class.getName(), "PasswordFieldUI", BasePasswordFieldUI.class.getName(), "ComboBoxUI", BaseComboBoxUI.class.getName(), "ToolTipUI", BaseToolTipUI.class.getName(), "TreeUI", BaseTreeUI.class.getName(), "TableUI", BaseTableUI.class.getName(), "TableHeaderUI", BaseTableHeaderUI.class.getName(), "ScrollBarUI", BaseScrollBarUI.class.getName(), "ProgressBarUI", BaseProgressBarUI.class.getName(), "FileChooserUI", BaseFileChooserUI.class.getName(), "MenuUI", BaseMenuUI.class.getName(), "PopupMenuUI", BasePopupMenuUI.class.getName(), "MenuItemUI", BaseMenuItemUI.class.getName(), "CheckBoxMenuItemUI", BaseCheckBoxMenuItemUI.class.getName(), "RadioButtonMenuItemUI", BaseRadioButtonMenuItemUI.class.getName(), "PopupMenuSeparatorUI", BaseSeparatorUI.class.getName(), "CheckBoxUI", BernsteinCheckBoxUI.class.getName(), "RadioButtonUI", BernsteinRadioButtonUI.class.getName(), "ButtonUI", BernsteinButtonUI.class.getName(), "SliderUI", BernsteinSliderUI.class.getName(), "PanelUI", BernsteinPanelUI.class.getName(), "ScrollPaneUI", BernsteinScrollPaneUI.class.getName(), "TabbedPaneUI", BernsteinTabbedPaneUI.class.getName(), "ToolBarUI", BernsteinToolBarUI.class.getName(), "MenuBarUI", BernsteinMenuBarUI.class.getName(), "SplitPaneUI", BernsteinSplitPaneUI.class.getName(), "InternalFrameUI", BernsteinInternalFrameUI.class.getName(), "RootPaneUI", BernsteinRootPaneUI.class.getName(), "DesktopPaneUI", BernsteinDesktopPaneUI.class.getName()};
        table.putDefaults(uiDefaults);
        table.put("FormattedTextFieldUI", BaseFormattedTextFieldUI.class.getName());
        table.put("SpinnerUI", BaseSpinnerUI.class.getName());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.put("SplitPane.centerOneTouchButtons", Boolean.FALSE);
    }

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }
}

