/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.rmi;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.WizardDialog;
import it.businesslogic.ireport.rmi.IReportServer;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.PageSize;
import java.awt.Frame;
import java.rmi.AlreadyBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class IReportServerImpl
extends UnicastRemoteObject
implements IReportServer,
Runnable {
    static IReportServerImpl mainInstance = null;

    public static IReportServerImpl getMainInstance() {
        if (mainInstance == null) {
            try {
                mainInstance = new IReportServerImpl();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return mainInstance;
    }

    IReportServerImpl() throws RemoteException {
    }

    public static void runServer() {
        System.setSecurityManager(new RMISecurityManager());
        Thread t = new Thread(IReportServerImpl.getMainInstance());
        t.start();
    }

    public void run() {
        try {
            int port = 2100;
            try {
                port = Integer.parseInt(MainFrame.getMainInstance().getProperties().getProperty("RMIServerPort", "2100"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Registry reg = LocateRegistry.createRegistry(port);
            reg.bind("iReportServer", this);
            System.out.println("RMI iReportServer waiting on port " + port + ".....");
        }
        catch (AlreadyBoundException abe) {
            System.out.println("Service already bound! Is another iReport instance running?");
        }
        catch (RemoteException re) {
            System.out.println("Remote exception: " + re.toString());
        }
    }

    public boolean ping() {
        return true;
    }

    public boolean setVisible(boolean b) {
        MainFrame.getMainInstance().setVisible(b);
        if (MainFrame.getMainInstance().getState() == 1) {
            MainFrame.getMainInstance().setState(0);
        }
        return MainFrame.getMainInstance().requestFocusInWindow();
    }

    public boolean openFile(String file) {
        this.setVisible(true);
        try {
            JReportFrame jrf = MainFrame.getMainInstance().openFile(file);
            jrf.setSelected(true);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean runWizard(String destFile) {
        MainFrame mainFrame = MainFrame.getMainInstance();
        if (mainFrame == null) {
            return false;
        }
        mainFrame.logOnConsole("Invocato wizard");
        mainFrame.logOnConsole("Pronto ad invocare la nuova finestra..." + Thread.currentThread().getName());
        try {
            WizardDialog wd = new WizardDialog((Frame)mainFrame, true);
            mainFrame.logOnConsole("Lancio wizard");
            wd.setVisible(true);
            wd.requestFocus();
            Report report = null;
            if (wd.getDialogResult() == 0) {
                report = wd.getReport();
                if (report == null) {
                    report = this.createBlankReport();
                }
            } else {
                report = this.createBlankReport();
            }
            if (report != null) {
                mainFrame.openNewReportWindow(report);
                report.setFilename(destFile);
                report.saveXMLFile();
                this.setVisible(true);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return true;
    }

    private Report createBlankReport() {
        Report newReport = new Report();
        newReport.setName(I18n.getString("untitledReport", "untitled_report_") + "1");
        newReport.setUsingMultiLineExpressions(false);
        newReport.setWidth(PageSize.A4.x);
        newReport.setHeight(PageSize.A4.y);
        newReport.setTopMargin(20);
        newReport.setLeftMargin(30);
        newReport.setRightMargin(30);
        newReport.setBottomMargin(20);
        newReport.setColumnCount(1);
        newReport.setColumnWidth(newReport.getWidth() - newReport.getLeftMargin() - newReport.getRightMargin());
        newReport.setColumnSpacing(0);
        return newReport;
    }
}

