/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Buildable;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.StringWriterIOException;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class GString
extends GroovyObjectSupport
implements Comparable,
CharSequence,
Writable,
Buildable,
Serializable {
    static final long serialVersionUID = -2638020355892246323L;
    private Object[] values;

    public GString(Object values) {
        this.values = (Object[])values;
    }

    public GString(Object[] values) {
        this.values = values;
    }

    public abstract String[] getStrings();

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e) {
            return InvokerHelper.invokeMethod(this.toString(), name, args);
        }
    }

    public Object[] getValues() {
        return this.values;
    }

    public GString plus(GString that) {
        ArrayList<String> stringList = new ArrayList<String>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        stringList.addAll(Arrays.asList(this.getStrings()));
        valueList.addAll(Arrays.asList(this.getValues()));
        if (stringList.size() > valueList.size()) {
            valueList.add("");
        }
        stringList.addAll(Arrays.asList(that.getStrings()));
        valueList.addAll(Arrays.asList(that.getValues()));
        final String[] newStrings = new String[stringList.size()];
        stringList.toArray(newStrings);
        Object[] newValues = valueList.toArray();
        return new GString(newValues){

            public String[] getStrings() {
                return newStrings;
            }
        };
    }

    public GString plus(String that) {
        String[] currentStrings = this.getStrings();
        String[] newStrings = null;
        Object[] newValues = null;
        newStrings = new String[currentStrings.length + 1];
        newValues = new Object[this.getValues().length + 1];
        int lastIndex = currentStrings.length;
        System.arraycopy(currentStrings, 0, newStrings, 0, lastIndex);
        System.arraycopy(this.getValues(), 0, newValues, 0, this.getValues().length);
        newStrings[lastIndex] = that;
        newValues[this.getValues().length] = "";
        final String[] finalStrings = newStrings;
        return new GString(newValues){

            public String[] getStrings() {
                return finalStrings;
            }
        };
    }

    public int getValueCount() {
        return this.values.length;
    }

    public Object getValue(int idx) {
        return this.values[idx];
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        try {
            this.writeTo(buffer);
        }
        catch (IOException e) {
            throw new StringWriterIOException(e);
        }
        return buffer.toString();
    }

    public Writer writeTo(Writer out) throws IOException {
        String[] s = this.getStrings();
        int numberOfValues = this.values.length;
        int size = s.length;
        for (int i = 0; i < size; ++i) {
            out.write(s[i]);
            if (i >= numberOfValues) continue;
            Object value = this.values[i];
            if (value instanceof Closure) {
                Closure c = (Closure)value;
                if (c.getMaximumNumberOfParameters() == 0) {
                    InvokerHelper.write(out, c.call(null));
                    continue;
                }
                if (c.getMaximumNumberOfParameters() == 1) {
                    c.call(new Object[]{out});
                    continue;
                }
                throw new GroovyRuntimeException("Trying to evaluate a GString containing a Closure taking " + c.getMaximumNumberOfParameters() + " parameters");
            }
            InvokerHelper.write(out, value);
        }
        return out;
    }

    public void build(GroovyObject builder) {
        String[] s = this.getStrings();
        int numberOfValues = this.values.length;
        int size = s.length;
        for (int i = 0; i < size; ++i) {
            builder.getProperty("mkp");
            builder.invokeMethod("yield", new Object[]{s[i]});
            if (i >= numberOfValues) continue;
            builder.getProperty("mkp");
            builder.invokeMethod("yield", new Object[]{this.values[i]});
        }
    }

    public boolean equals(Object that) {
        if (that instanceof GString) {
            return this.equals((GString)that);
        }
        return false;
    }

    public boolean equals(GString that) {
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return 37 + this.toString().hashCode();
    }

    public int compareTo(Object that) {
        return this.toString().compareTo(that.toString());
    }

    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public int length() {
        return this.toString().length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public Pattern negate() {
        return DefaultGroovyMethods.bitwiseNegate(this.toString());
    }
}

