/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.microutil;

public class MicroTabletParameters {
    int tabletXStart;
    int tabletXStop;
    int tabletYStart;
    int tabletYStop;
    int tabletFilterPoints;
    int tabletTimingAdvance;
    int tabletBaudRate;
    int tabletResolution;
    int tabletRotationMode;
    String tabletComPort = "COM1";
    boolean tabletComTest = false;
    int tabletFormat;
    String tabletModel;
    boolean tabletClippingMode = false;
    int tabletLogicalXSize;
    int tabletLogicalYSize;
    int tabletMaxPointDelta = Short.MAX_VALUE;

    public MicroTabletParameters() {
        this.setTabletModel("SignatureGem1X5");
    }

    public int getTabletLogicalXSize() {
        return this.tabletLogicalXSize;
    }

    public int getTabletLogicalYSize() {
        return this.tabletLogicalYSize;
    }

    public int getTabletXStart() {
        return this.tabletXStart;
    }

    public void setTabletXStart(int newValue) {
        this.calcLogicalSizes();
        this.tabletXStart = newValue;
    }

    public int getTabletXStop() {
        return this.tabletXStop;
    }

    public void setTabletXStop(int newValue) {
        this.calcLogicalSizes();
        this.tabletXStop = newValue;
    }

    public int getTabletYStart() {
        return this.tabletYStart;
    }

    public void setTabletYStart(int newValue) {
        this.calcLogicalSizes();
        this.tabletYStart = newValue;
    }

    public int getTabletYStop() {
        return this.tabletYStop;
    }

    public void setTabletYStop(int newValue) {
        this.calcLogicalSizes();
        this.tabletYStop = newValue;
    }

    public int getTabletFilterPoints() {
        return this.tabletFilterPoints;
    }

    public void setTabletFilterPoints(int newValue) {
        this.tabletFilterPoints = newValue;
    }

    public int getTabletTimingAdvance() {
        return this.tabletTimingAdvance;
    }

    public void setTabletTimingAdvance(int newValue) {
        this.tabletTimingAdvance = newValue;
    }

    public int getTabletBaudRate() {
        return this.tabletBaudRate;
    }

    public void setTabletBaudRate(int newValue) {
        this.tabletBaudRate = newValue;
    }

    public int getTabletRotationMode() {
        return this.tabletRotationMode;
    }

    public void setTabletResolution(int newValue) {
        this.tabletResolution = newValue;
    }

    public int getTabletResolution() {
        return this.tabletResolution;
    }

    public void setTabletRotationMode(int newValue) {
        this.tabletRotationMode = newValue;
    }

    public boolean getTabletComTest() {
        return this.tabletComTest;
    }

    public void setTabletComTest(boolean newValue) {
        this.tabletComTest = newValue;
    }

    public String getTabletComPort() {
        return this.tabletComPort;
    }

    public void setTabletComPort(String newValue) {
        this.tabletComPort = newValue;
    }

    public int getTabletFormat() {
        return this.tabletFormat;
    }

    public void setTabletFormat(int newValue) {
        this.tabletFormat = newValue;
    }

    public String getTabletModel() {
        return this.tabletModel;
    }

    public void setTabletModel(String model) {
        this.tabletModel = model;
        if (model.equals("SignatureGem1X5")) {
            this.setTabletParameters(400, 2400, 350, 950, 4, 4, 19200, 410, 0, 0);
            return;
        }
        if (model.equals("SignatureGemLCD")) {
            this.setTabletParameters(400, 2400, 350, 1250, 4, 4, 19200, 410, 0, 1);
            return;
        }
        if (model.equals("SignatureGem4X5")) {
            this.setTabletParameters(500, 2650, 700, 2100, 4, 4, 19200, 410, 0, 0);
            return;
        }
        if (model.equals("ClipGem")) {
            this.setTabletParameters(485, 2800, 170, 3200, 2, 2, 9600, 275, 0, 0);
            return;
        }
        if (model.equals("ClipGem19200")) {
            this.setTabletParameters(485, 2800, 170, 3200, 4, 4, 19200, 275, 0, 0);
            return;
        }
        if (model.equals("ClipGemLGL")) {
            this.setTabletParameters(400, 2400, 150, 3450, 4, 4, 19200, 240, 0, 0);
            return;
        }
        if (model.equals("MicroGem4X5")) {
            this.setTabletParameters(500, 2650, 700, 2100, 2, 2, 19200, 410, 0, 1);
            return;
        }
        if (model.equals("MicroGemLCD")) {
            this.setTabletParameters(900, 2200, 800, 1400, 2, 2, 19200, 410, 0, 1);
            return;
        }
        if (model.equals("TracGem")) {
            this.setTabletParameters(900, 2200, 700, 1300, 2, 2, 19200, 275, 0, 1);
            return;
        }
        if (model.equals("PaperGem")) {
            this.setTabletParameters(450, 2850, 400, 3300, 2, 2, 19200, 275, 0, 1);
            return;
        }
        if (model.equals("SigLite")) {
            this.setTabletParameters(0, 6143, 6143, 0, 2, 2, 19200, 400, 0, 2);
            return;
        }
    }

    public boolean getTabletClippingMode() {
        return this.tabletClippingMode;
    }

    public void setTabletClippingMode(boolean newValue) {
        this.tabletClippingMode = newValue;
    }

    void setTabletParameters(int xStart, int xStop, int yStart, int yStop, int filterPoints, int timingAdvance, int baudRate, int resolution, int rotationMode, int format) {
        this.tabletXStart = xStart;
        this.tabletXStop = xStop;
        this.tabletYStart = yStart;
        this.tabletYStop = yStop;
        this.tabletFilterPoints = filterPoints;
        this.tabletTimingAdvance = timingAdvance;
        this.tabletBaudRate = baudRate;
        this.tabletResolution = resolution;
        this.tabletRotationMode = 0;
        this.tabletFormat = format;
        this.calcLogicalSizes();
    }

    void calcLogicalSizes() {
        this.tabletLogicalXSize = this.tabletXStop - this.tabletXStart;
        this.tabletLogicalYSize = this.tabletYStop - this.tabletYStart;
    }

    public int getTabletMaxPointDelta() {
        return this.tabletMaxPointDelta;
    }

    public void setTabletMaxPointDelta(int newDelta) {
        this.tabletMaxPointDelta = newDelta;
    }
}

