/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus;

import com.topaz.sigplus.SigPlusEvent0;
import com.topaz.sigplus.SigPlusListener;
import com.topaz.sigplus.TopazSigCapData;
import com.topaz.sigplus.util.CharacterMap;
import com.topaz.sigplus.util.LCDTextGraphicsSupport;
import com.topaz.sigplus.util.SigCrypt;
import com.topaz.sigplus.util.SigDataEventHandler;
import com.topaz.sigplus.util.SigDataPoint;
import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigDrawParameters;
import com.topaz.sigplus.util.SigDrawType;
import com.topaz.sigplus.util.SigInfo;
import com.topaz.sigplus.util.SigReader;
import com.topaz.sigplus.util.SigWriter;
import com.topaz.sigplus.util.TabletInterface;
import com.topaz.sigplus.util.TabletParameters;
import java.util.Vector;

public class SigPlusText
implements SigDataEventHandler {
    static final String SigPlusVersion = "SigPlusJava v2.22";
    private transient SigDataType sig;
    private transient TabletInterface tablet;
    private transient int tabletState;
    private transient int compressionMode;
    private transient SigCrypt cryptor;
    private SigDrawParameters displayParams;
    private SigDrawParameters imageParams;
    private TabletParameters tabParams;
    private Vector m_SigPlusListeners = new Vector();
    private LCDTextGraphicsSupport lcdGraphics;

    public SigPlusText() {
        this.tabParams = new TabletParameters();
        this.displayParams = new SigDrawParameters();
        this.imageParams = new SigDrawParameters();
        this.cryptor = new SigCrypt();
        this.initSigPlus();
    }

    void initSigPlus() {
        this.sig = new SigDataType();
        this.sig.setNewDataHandler(this);
        this.tablet = new TabletInterface(this.tabParams, this.sig);
        this.lcdGraphics = new LCDTextGraphicsSupport(this.tablet);
        this.tabletState = 0;
        this.compressionMode = 0;
    }

    public void fireNewData() {
    }

    public void fireNewKeyPadData() {
        this.fireKeyPadData();
    }

    public synchronized void addSigPlusListener(SigPlusListener l) {
        this.m_SigPlusListeners.addElement(l);
    }

    public synchronized void removeSigPlusListener(SigPlusListener l) {
        this.m_SigPlusListeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTabletTimerEvent() {
        Vector l;
        SigPlusEvent0 evt = new SigPlusEvent0(this);
        SigPlusText sigPlusText = this;
        synchronized (sigPlusText) {
            l = (Vector)this.m_SigPlusListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((SigPlusListener)l.elementAt(i)).handleTabletTimerEvent(evt);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNewTabletData() {
        Vector l;
        SigPlusEvent0 evt = new SigPlusEvent0(this);
        SigPlusText sigPlusText = this;
        synchronized (sigPlusText) {
            l = (Vector)this.m_SigPlusListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((SigPlusListener)l.elementAt(i)).handleNewTabletData(evt);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireKeyPadData() {
        Vector l;
        SigPlusEvent0 evt = new SigPlusEvent0(this);
        SigPlusText sigPlusText = this;
        synchronized (sigPlusText) {
            l = (Vector)this.m_SigPlusListeners.clone();
        }
        int i = 0;
        while (i < l.size()) {
            ((SigPlusListener)l.elementAt(i)).handleKeyPadData(evt);
            ++i;
        }
    }

    public boolean exportSigFile(String fileName) {
        SigWriter writer = new SigWriter(this.compressionMode, this.cryptor);
        boolean status = writer.writeSigToFile(fileName, this.sig, this.displayParams, this.imageParams);
        return status;
    }

    public boolean importSigFile(String fileName) {
        SigReader reader = new SigReader(this.compressionMode, this.cryptor);
        boolean status = reader.readSigFromFile(fileName, this.sig, this.displayParams, this.imageParams);
        return status;
    }

    public void clearTablet() {
        this.sig.clearSig();
        this.tablet.badPointCounter = 0;
    }

    public void keyPadSetSigWindow(int coords, int xPos, int yPos, int xSize, int ySize) {
        this.sig.setSigWindow(this.tabParams, coords, xPos, yPos, xSize, ySize);
    }

    public void keyPadClearSigWindow(int inside) {
        this.sig.clearSigWindow(inside);
    }

    public void keyPadAddHotSpot(int keyCode, int coords, int xPos, int yPos, int xSize, int ySize) {
        this.sig.addHotSpot(this.tabParams, keyCode, coords, xPos, yPos, xSize, ySize);
    }

    public void keyPadClearHotSpotList() {
        this.sig.clearHotSpotList();
    }

    public int keyPadQueryHotSpot(int keyCode) {
        return this.sig.queryHotSpot(keyCode);
    }

    public int getLCDCaptureMode() {
        return this.tabParams.getTabletLCDCaptureMode();
    }

    public void setLCDCaptureMode(int newMode) {
        this.tabParams.setTabletLCDCaptureMode(newMode);
        if (this.tabletState != 0) {
            this.tablet.lcdTabletSetup();
        }
    }

    public boolean lcdSetWindow(int xPos, int yPos, int xSize, int ySize) {
        return this.tablet.lcdSetWindow(xPos, yPos, xSize, ySize);
    }

    public boolean lcdRefresh(int mode, int xPos, int yPos, int xSize, int ySize) {
        return this.tablet.lcdRefresh(mode, xPos, yPos, xSize, ySize);
    }

    public String getTimeStamp() {
        return this.sig.getTimeStamp();
    }

    public void setTimeStamp(String newValue) {
        this.sig.setTimeStamp(newValue);
    }

    public String getAnnotation() {
        return this.sig.getAnnotation();
    }

    public void setAnnotation(String newValue) {
        this.sig.setAnnotation(newValue);
    }

    public String getSigString() {
        SigWriter writer = new SigWriter(this.compressionMode, this.cryptor);
        byte[] buffer = writer.writeSigToByteArray(this.sig, this.displayParams, this.imageParams);
        String str = this.convertByteArrayToHexString(buffer);
        return str;
    }

    public void setSigString(String sigString) {
        SigReader reader = new SigReader(this.compressionMode, this.cryptor);
        byte[] buffer = this.convertHexStringToByteArray(sigString);
        reader.readSigFromByteArray(buffer, this.sig, this.displayParams, this.imageParams);
    }

    public int getTabletState() {
        return this.tabletState;
    }

    public void setTabletState(int newValue) {
        if (newValue == 1 && this.tabletState == 0) {
            if (this.tablet.openTablet()) {
                this.tabletState = 1;
                this.tablet.lcdTabletSetup();
            }
        } else {
            this.tablet.closeTablet();
            this.tabletState = 0;
        }
    }

    public int getTabletLogicalXSize() {
        return this.tabParams.getTabletLogicalXSize();
    }

    public int getTabletLogicalYSize() {
        return this.tabParams.getTabletLogicalYSize();
    }

    public int getTabletXStart() {
        return this.tabParams.getTabletXStart();
    }

    public void setTabletXStart(int newValue) {
        this.tabParams.setTabletXStart(newValue);
    }

    public int getTabletXStop() {
        return this.tabParams.getTabletXStop();
    }

    public void setTabletXStop(int newValue) {
        this.tabParams.setTabletXStop(newValue);
    }

    public int getTabletYStart() {
        return this.tabParams.getTabletYStart();
    }

    public void setTabletYStart(int newValue) {
        this.tabParams.setTabletYStart(newValue);
    }

    public int getTabletYStop() {
        return this.tabParams.getTabletYStop();
    }

    public void setTabletYStop(int newValue) {
        this.tabParams.setTabletYStop(newValue);
    }

    public int getTabletFilterPoints() {
        return this.tabParams.getTabletFilterPoints();
    }

    public void setTabletFilterPoints(int newValue) {
        this.tabParams.setTabletFilterPoints(newValue);
    }

    public int getTabletTimingAdvance() {
        return this.tabParams.getTabletTimingAdvance();
    }

    public void setTabletTimingAdvance(int newValue) {
        this.tabParams.setTabletTimingAdvance(newValue);
    }

    public int getTabletBaudRate() {
        return this.tabParams.getTabletBaudRate();
    }

    public void setTabletBaudRate(int newValue) {
        this.tabParams.setTabletBaudRate(newValue);
    }

    public int getTabletResolution() {
        return this.tabParams.getTabletResolution();
    }

    public void setTabletResolution(int newValue) {
        this.tabParams.setTabletResolution(newValue);
    }

    public int getTabletRotation() {
        return this.tabParams.getTabletRotationMode();
    }

    public void setTabletRotation(int newValue) {
        this.tabParams.setTabletRotationMode(newValue);
    }

    public String getTabletComPort() {
        return this.tabParams.getTabletComPort();
    }

    public void setTabletComPort(String newValue) {
        this.tabParams.setTabletComPort(newValue);
    }

    public boolean getTabletComTest() {
        return this.tabParams.getTabletComTest();
    }

    public void setTabletComTest(boolean newValue) {
        this.tabParams.setTabletComTest(newValue);
    }

    public int getTabletFormat() {
        return this.tabParams.getTabletFormat();
    }

    public void setTabletFormat(int newValue) {
        this.tabParams.setTabletFormat(newValue);
    }

    public String getTabletModel() {
        return this.tabParams.getTabletModel();
    }

    public void setTabletModel(String newValue) {
        boolean oldLcd = false;
        if (newValue == "SignatureGemLCD4X3") {
            if (this.tabletState == 0) {
                if (this.tablet.openTablet()) {
                    oldLcd = this.tablet.isRI();
                    this.tablet.closeTablet();
                }
            } else {
                oldLcd = this.tablet.isRI();
            }
            if (oldLcd) {
                this.tabParams.setTabletModel("SignatureGemLCD4X3Old");
            } else {
                this.tabParams.setTabletModel("SignatureGemLCD4X3New");
            }
        } else {
            this.tabParams.setTabletModel(newValue);
        }
    }

    public boolean getTabletClippingMode() {
        return this.tabParams.getTabletClippingMode();
    }

    public void setTabletClippingMode(boolean newValue) {
        this.tabParams.setTabletClippingMode(newValue);
    }

    public int getTabletLCDType() {
        return this.tabParams.getTabletLCDType();
    }

    public void getTabletLCDType(int newValue) {
        this.tabParams.setTabletLCDType(newValue);
    }

    public int getTabletLCDXSize() {
        return this.tabParams.getTabletLCDXSize();
    }

    public void setTabletLCDXSize(int newValue) {
        this.tabParams.setTabletLCDXSize(newValue);
    }

    public int getTabletLCDYSize() {
        return this.tabParams.getTabletLCDYSize();
    }

    public void setTabletLCDYSize(int newValue) {
        this.tabParams.setTabletLCDYSize(newValue);
    }

    public int getTabletLCDXStart() {
        return this.tabParams.getTabletLCDXStart();
    }

    public void setTabletLCDXStart(int newValue) {
        this.tabParams.setTabletLCDXStart(newValue);
    }

    public int getTabletLCDXStop() {
        return this.tabParams.getTabletLCDXStop();
    }

    public void setTabletLCDXStop(int newValue) {
        this.tabParams.setTabletLCDXStop(newValue);
    }

    public int getTabletLCDYStart() {
        return this.tabParams.getTabletLCDYStart();
    }

    public void setTabletLCDYStart(int newValue) {
        this.tabParams.setTabletLCDYStart(newValue);
    }

    public int getTabletLCDYStop() {
        return this.tabParams.getTabletLCDYStop();
    }

    public void setTabletLCDYStop(int newValue) {
        this.tabParams.setTabletLCDYStop(newValue);
    }

    public float getDisplayPenWidth() {
        return this.displayParams.getPenWidth();
    }

    public void setDisplayPenWidth(float newValue) {
        this.displayParams.setPenWidth(newValue);
    }

    public boolean getDisplayTransparentMode() {
        return this.displayParams.getTransparentMode();
    }

    public void setDisplayTransparentMode(boolean newValue) {
        this.displayParams.setTransparentMode(newValue);
    }

    public int getDisplayRotation() {
        return this.displayParams.getRotation();
    }

    public void setDisplayRotation(int newValue) {
        this.displayParams.setRotation(newValue);
    }

    public int getDisplayJustifyX() {
        return this.displayParams.getJustifyX();
    }

    public void setDisplayJustifyX(int newValue) {
        this.displayParams.setJustifyX(newValue);
    }

    public int getDisplayJustifyY() {
        return this.displayParams.getJustifyY();
    }

    public void setDisplayJustifyY(int newValue) {
        this.displayParams.setJustifyY(newValue);
    }

    public int getDisplayJustifyMode() {
        return this.displayParams.getJustifyMode();
    }

    public void setDisplayJustifyMode(int newValue) {
        this.displayParams.setJustifyMode(newValue);
    }

    public int getDisplayDisplayMode() {
        return this.displayParams.getDisplayMode();
    }

    public void setDisplayDisplayMode(int newValue) {
        this.displayParams.setDisplayMode(newValue);
    }

    public int getDisplayTimeStampX() {
        return this.displayParams.getTimeStampX();
    }

    public void setDisplayTimeStampX(int newValue) {
        this.displayParams.setTimeStampX(newValue);
    }

    public int getDisplayTimeStampY() {
        return this.displayParams.getTimeStampY();
    }

    public void setDisplayTimeStampY(int newValue) {
        this.displayParams.setTimeStampY(newValue);
    }

    public int getDisplayTimeStampSize() {
        return this.displayParams.getTimeStampSize();
    }

    public void setDisplayTimeStampSize(int newValue) {
        this.displayParams.setTimeStampSize(newValue);
    }

    public int getDisplayAnnotationX() {
        return this.displayParams.getAnnotationX();
    }

    public void setDisplayAnnotationX(int newValue) {
        this.displayParams.setAnnotationX(newValue);
    }

    public int getDisplayAnnotationY() {
        return this.displayParams.getAnnotationY();
    }

    public void setDisplayAnnotationY(int newValue) {
        this.displayParams.setAnnotationY(newValue);
    }

    public int getDisplayAnnotationSize() {
        return this.displayParams.getAnnotationSize();
    }

    public void setDisplayAnnotationSize(int newValue) {
        this.displayParams.setAnnotationSize(newValue);
    }

    public boolean getDisplayTimeStamp() {
        return this.displayParams.getTimeStamp();
    }

    public void setDisplayTimeStamp(boolean newValue) {
        this.displayParams.setTimeStamp(newValue);
    }

    public boolean getDisplayAnnotation() {
        return this.displayParams.getAnnotation();
    }

    public void setDisplayAnnotation(boolean newValue) {
        this.displayParams.setAnnotation(newValue);
    }

    public int getImageXSize() {
        return this.imageParams.getXSize();
    }

    public void setImageXSize(int newValue) {
        this.imageParams.setXSize(newValue);
    }

    public int getImageYSize() {
        return this.imageParams.getYSize();
    }

    public void setImageYSize(int newValue) {
        this.imageParams.setYSize(newValue);
    }

    public float getImagePenWidth() {
        return this.imageParams.getPenWidth();
    }

    public void setImagePenWidth(float newValue) {
        this.imageParams.setPenWidth(newValue);
    }

    public boolean getImageTransparentMode() {
        return this.imageParams.getTransparentMode();
    }

    public void setImageTransparentMode(boolean newValue) {
        this.imageParams.setTransparentMode(newValue);
    }

    public int getImageRotation() {
        return this.imageParams.getRotation();
    }

    public void setImageRotation(int newValue) {
        this.imageParams.setRotation(newValue);
    }

    public int getImageJustifyX() {
        return this.imageParams.getJustifyX();
    }

    public void setImageJustifyX(int newValue) {
        this.imageParams.setJustifyX(newValue);
    }

    public int getImageJustifyY() {
        return this.imageParams.getJustifyY();
    }

    public void setImageJustifyY(int newValue) {
        this.imageParams.setJustifyY(newValue);
    }

    public int getImageJustifyMode() {
        return this.imageParams.getJustifyMode();
    }

    public void setImageJustifyMode(int newValue) {
        this.imageParams.setJustifyMode(newValue);
    }

    public int getImageDisplayMode() {
        return this.imageParams.getDisplayMode();
    }

    public void setImageDisplayMode(int newValue) {
        this.imageParams.setDisplayMode(newValue);
    }

    public int getImageTimeStampX() {
        return this.imageParams.getTimeStampX();
    }

    public void setImageTimeStampX(int newValue) {
        this.imageParams.setTimeStampX(newValue);
    }

    public int getImageTimeStampY() {
        return this.imageParams.getTimeStampY();
    }

    public void setImageTimeStampY(int newValue) {
        this.imageParams.setTimeStampY(newValue);
    }

    public int getImageTimeStampSize() {
        return this.imageParams.getTimeStampSize();
    }

    public void setImageTimeStampSize(int newValue) {
        this.imageParams.setTimeStampSize(newValue);
    }

    public int getImageAnnotationX() {
        return this.imageParams.getAnnotationX();
    }

    public void setImageAnnotationX(int newValue) {
        this.imageParams.setAnnotationX(newValue);
    }

    public int getImageAnnotationY() {
        return this.imageParams.getAnnotationY();
    }

    public void setImageAnnotationY(int newValue) {
        this.imageParams.setAnnotationY(newValue);
    }

    public int getImageAnnotationSize() {
        return this.imageParams.getAnnotationSize();
    }

    public void setImageAnnotationSize(int newValue) {
        this.imageParams.setAnnotationSize(newValue);
    }

    public boolean getImageTimeStamp() {
        return this.imageParams.getTimeStamp();
    }

    public void setImageTimeStamp(boolean newValue) {
        this.imageParams.setTimeStamp(newValue);
    }

    public boolean getImageAnnotation() {
        return this.imageParams.getAnnotation();
    }

    public void setImageAnnotation(boolean newValue) {
        this.imageParams.setAnnotation(newValue);
    }

    public void autoKeyAddData(byte[] buffer) {
        this.cryptor.autoKeyAddData(buffer, this.sig);
    }

    public void autoKeyFinish() {
        this.cryptor.autoKeyFinish(this.sig);
    }

    public void autoKeyStart() {
        this.cryptor.autoKeyStart(this.sig);
    }

    public int getEncryptionMode() {
        return this.cryptor.getEncryptionMode();
    }

    public int getKeyReceipt() {
        return this.cryptor.getKeyReceipt();
    }

    public String getKeyReceiptAscii() {
        return this.cryptor.getKeyReceiptAscii();
    }

    public String getKeyString() {
        return this.cryptor.getKeyString();
    }

    public boolean getSaveSigInfo() {
        return this.sig.getSaveSigInfo();
    }

    public int getSigCompressionMode() {
        return this.compressionMode;
    }

    public String getSigPlusVersion() {
        return SigPlusVersion;
    }

    public int getSigReceipt() {
        return this.cryptor.getSigReceipt(this.sig, this.displayParams, this.imageParams, this.compressionMode);
    }

    public String getSigReceiptAscii() {
        return this.cryptor.getSigReceiptAscii(this.sig, this.displayParams, this.imageParams, this.compressionMode);
    }

    public int numberOfTabletPoints() {
        SigInfo info = new SigInfo();
        this.sig.getSigData(info);
        return info.getNumPoints();
    }

    public void setAutoKeyData(String autoKeyData) {
        this.cryptor.setAutoKeyData(autoKeyData, this.sig);
    }

    public void setEncryptionMode(int encryptionMode) {
        this.cryptor.setEncryptionMode(encryptionMode, this.sig);
    }

    public void setKeyString(String keyString) {
        this.cryptor.setKeyString(keyString, this.sig);
    }

    public void setSaveSigInfo(boolean saveSigInfo) {
        this.sig.setSaveSigInfo(saveSigInfo);
    }

    public void setSigCompressionMode(int compMode) {
        this.compressionMode = compMode;
    }

    public int getBadPointCounter() {
        return this.tablet.badPointCounter;
    }

    public long getModelNumber() {
        return this.tablet.getTabletModelNumber();
    }

    public String getPdfString() {
        SigDrawType pdfDraw = new SigDrawType(this.sig, this.tabParams);
        return pdfDraw.getPdfString(this.imageParams);
    }

    public long getSerialNumber() {
        return this.tablet.getTabletSerialNumber();
    }

    public TopazSigCapData getSignatureData() {
        TopazSigCapData sigCapData = new TopazSigCapData();
        int numPoints = 0;
        int numStrokes = 0;
        int numStrokePoints = 0;
        int numPointsInVect = 0;
        int numPointsExtracted = 0;
        SigInfo sigData = new SigInfo();
        this.sig.getSigData(sigData);
        numStrokes = sigData.getNumStrokes();
        numPoints = sigData.getNumPoints();
        if (numPoints > 0) {
            sigCapData.m_PointArray = new SigDataPoint[numPoints + numStrokes];
            Vector tmpVect = sigData.getPointData();
            int j = 0;
            while (j < numStrokes) {
                numStrokePoints = sigData.getNumPointsInStroke(j);
                int i = 0;
                while (i < numStrokePoints) {
                    SigDataPoint tmpDataPoint = (SigDataPoint)tmpVect.elementAt(numPointsInVect);
                    sigCapData.m_PointArray[numPointsExtracted] = new SigDataPoint(tmpDataPoint.x, tmpDataPoint.y, 0L);
                    ++numPointsInVect;
                    ++numPointsExtracted;
                    ++i;
                }
                sigCapData.m_PointArray[numPointsExtracted] = new SigDataPoint(65535, 65535, 0L);
                ++numPointsExtracted;
                ++j;
            }
            sigCapData.m_byRawData = this.getSigString();
        }
        return sigCapData;
    }

    public int getTabletMaxPointDelta() {
        return this.tabParams.getTabletMaxPointDelta();
    }

    public void setTabletMaxPointDelta(int newDelta) {
        this.tabParams.setTabletMaxPointDelta(newDelta);
    }

    private byte[] convertHexStringToByteArray(String hexStr) {
        byte[] buffer = new byte[hexStr.length() / 2];
        int i = 0;
        int j = 0;
        while (j < buffer.length) {
            char msNibble = hexStr.charAt(i++);
            char lsNibble = hexStr.charAt(i++);
            int outByte = this.fromHex(msNibble) << 4 | this.fromHex(lsNibble);
            buffer[j] = (byte)outByte;
            ++j;
        }
        return buffer;
    }

    private String convertByteArrayToHexString(byte[] byteArray) {
        String buffer = new String();
        int j = 0;
        while (j < byteArray.length) {
            int msNibble = (byteArray[j] & 0xF0) >> 4;
            int lsNibble = byteArray[j] & 0xF;
            buffer = String.valueOf(buffer) + this.toHex(msNibble);
            buffer = String.valueOf(buffer) + this.toHex(lsNibble);
            ++j;
        }
        return buffer;
    }

    private int fromHex(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 'a' && hexChar <= 'f') {
            return hexChar - 97 + 10;
        }
        return 0;
    }

    private char toHex(int hexInt) {
        if (hexInt < 10) {
            int returnChar = (hexInt & 0xF) + 48;
            return (char)returnChar;
        }
        int returnChar = (hexInt & 0xF) - 10 + 65;
        return (char)returnChar;
    }

    public boolean lcdWriteImage(int dest, int mode, int xPos, int yPos, int xSize, int ySize, byte[] imageData) {
        return this.lcdGraphics.lcdWriteImage(dest, mode, xPos, yPos, xSize, ySize, imageData);
    }

    public boolean lcdWriteImageFile(int dest, int mode, int xPos, int yPos, String fileName) {
        return this.lcdGraphics.lcdWriteImageFile(dest, mode, xPos, yPos, fileName);
    }

    public boolean lcdWriteString(int dest, int mode, int xPos, int yPos, String text, CharacterMap typeFace) {
        return this.lcdGraphics.lcdWriteString(dest, mode, xPos, yPos, text, typeFace);
    }

    public void setLCDTabletMap(int newLCDType, int newLCDXSize, int newLCDYSize, int newLCDXStart, int newLCDYStart, int newLCDXStop, int newLCDYStop, int newLCDCompMode, int newLCDFastComp, int newLCDSlowComp) {
        this.tabParams.setTabletLCDParameters(newLCDType, newLCDXSize, newLCDYSize, newLCDXStart, newLCDYStart, newLCDXStop, newLCDYStop, newLCDCompMode, newLCDFastComp, newLCDSlowComp);
    }
}

