/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.jruby;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyNil;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.util.ClassUtils;

public abstract class JRubyScriptUtils {
    public static Object createJRubyObject(String scriptSource, Class[] interfaces) throws JumpException {
        Ruby ruby = Ruby.getDefaultInstance();
        IRubyObject rubyObject = ruby.evalScript(scriptSource);
        if (rubyObject instanceof RubyNil) {
            throw new ScriptCompilationException("Compilation of JRuby script returned '" + rubyObject + "'");
        }
        return Proxy.newProxyInstance(ClassUtils.getDefaultClassLoader(), interfaces, (InvocationHandler)new RubyObjectInvocationHandler(rubyObject, ruby));
    }

    private static class RubyObjectInvocationHandler
    implements InvocationHandler {
        private final IRubyObject rubyObject;
        private final Ruby ruby;

        public RubyObjectInvocationHandler(IRubyObject rubyObject, Ruby ruby) {
            this.rubyObject = rubyObject;
            this.ruby = ruby;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            IRubyObject[] rubyArgs = this.convertToRuby(args);
            IRubyObject result = this.rubyObject.callMethod(method.getName(), rubyArgs);
            return JavaUtil.convertRubyToJava((IRubyObject)result);
        }

        private IRubyObject[] convertToRuby(Object[] javaArgs) {
            if (javaArgs == null || javaArgs.length == 0) {
                return new IRubyObject[0];
            }
            return JavaUtil.convertJavaArrayToRuby((Ruby)this.ruby, (Object[])javaArgs);
        }
    }
}

