/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.rmi.CodebaseAwareObjectInputStream;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public abstract class AbstractHttpInvokerRequestExecutor
implements HttpInvokerRequestExecutor {
    private static final int SERIALIZED_INVOCATION_BYTE_ARRAY_INITIAL_SIZE = 1024;
    protected static final String CONTENT_TYPE_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    protected static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    protected static final String HTTP_METHOD_POST = "POST";
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$remoting$support$RemoteInvocationResult;

    public final RemoteInvocationResult executeRequest(HttpInvokerClientConfiguration config, RemoteInvocation invocation) throws Exception {
        ByteArrayOutputStream baos = this.getByteArrayOutputStream(invocation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending HTTP invoker request for service at [" + config.getServiceUrl() + "], with size " + baos.size()));
        }
        return this.doExecuteRequest(config, baos);
    }

    protected ByteArrayOutputStream getByteArrayOutputStream(RemoteInvocation invocation) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        this.writeRemoteInvocation(invocation, baos);
        return baos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRemoteInvocation(RemoteInvocation invocation, OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(this.decorateOutputStream(os));
        try {
            this.doWriteRemoteInvocation(invocation, oos);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }

    protected OutputStream decorateOutputStream(OutputStream os) throws IOException {
        return os;
    }

    protected void doWriteRemoteInvocation(RemoteInvocation invocation, ObjectOutputStream oos) throws IOException {
        oos.writeObject(invocation);
    }

    protected abstract RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration var1, ByteArrayOutputStream var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocationResult readRemoteInvocationResult(InputStream is, String codebaseUrl) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = this.createObjectInputStream(this.decorateInputStream(is), codebaseUrl);
        try {
            RemoteInvocationResult remoteInvocationResult = this.doReadRemoteInvocationResult(ois);
            return remoteInvocationResult;
        }
        finally {
            ois.close();
        }
    }

    protected InputStream decorateInputStream(InputStream is) throws IOException {
        return is;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is, String codebaseUrl) throws IOException {
        return new CodebaseAwareObjectInputStream(is, codebaseUrl);
    }

    protected RemoteInvocationResult doReadRemoteInvocationResult(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object obj = ois.readObject();
        if (!(obj instanceof RemoteInvocationResult)) {
            throw new RemoteException("Deserialized object needs to be assignable to type [" + (class$org$springframework$remoting$support$RemoteInvocationResult == null ? (class$org$springframework$remoting$support$RemoteInvocationResult = AbstractHttpInvokerRequestExecutor.class$("org.springframework.remoting.support.RemoteInvocationResult")) : class$org$springframework$remoting$support$RemoteInvocationResult).getName() + "]: " + obj);
        }
        return (RemoteInvocationResult)obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

