/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.util.Assert;

public class SQLErrorCodesFactory {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$SQLErrorCodesFactory == null ? (class$org$springframework$jdbc$support$SQLErrorCodesFactory = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodesFactory")) : class$org$springframework$jdbc$support$SQLErrorCodesFactory));
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/springframework/jdbc/support/sql-error-codes.xml";
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map dataSourceProductNames = new HashMap(10);
    private final Map rdbmsErrorCodes;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodesFactory;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodes;

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        HashMap<String, SQLErrorCodes> errorCodes = null;
        try {
            DefaultListableBeanFactory lbf = new DefaultListableBeanFactory();
            XmlBeanDefinitionReader bdr = new XmlBeanDefinitionReader(lbf);
            Resource resource = this.loadResource(SQL_ERROR_CODE_DEFAULT_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
            } else {
                logger.warn((Object)"Default sql-error-codes.xml not found (should be included in spring.jar)");
            }
            resource = this.loadResource(SQL_ERROR_CODE_OVERRIDE_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
                logger.info((Object)"Found custom sql-error-codes.xml file at the root of the classpath");
            }
            Map errorCodeBeans = lbf.getBeansOfType(class$org$springframework$jdbc$support$SQLErrorCodes == null ? (class$org$springframework$jdbc$support$SQLErrorCodes = SQLErrorCodesFactory.class$("org.springframework.jdbc.support.SQLErrorCodes")) : class$org$springframework$jdbc$support$SQLErrorCodes, true, false);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("SQLErrorCodes loaded: " + errorCodeBeans.keySet()));
            }
            errorCodes = new HashMap(errorCodeBeans.size());
            Iterator it = errorCodeBeans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String beanName = (String)entry.getKey();
                SQLErrorCodes ec = (SQLErrorCodes)entry.getValue();
                String[] names = ec.getDatabaseProductNames();
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        errorCodes.put(names[i], ec);
                    }
                    continue;
                }
                errorCodes.put(beanName, ec);
            }
        }
        catch (BeansException ex) {
            logger.warn((Object)"Error loading SQL error codes from config file", (Throwable)ex);
            errorCodes = new HashMap<String, SQLErrorCodes>(0);
        }
        this.rdbmsErrorCodes = errorCodes;
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path);
    }

    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        String dataSourceDbName;
        Assert.notNull(dataSource, "DataSource must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking up default SQLErrorCodes for DataSource [" + dataSource + "]"));
        }
        if ((dataSourceDbName = (String)this.dataSourceProductNames.get(dataSource)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Database product name found in cache for DataSource [" + dataSource + "]: name is '" + dataSourceDbName + "'"));
            }
            return this.getErrorCodes(dataSourceDbName);
        }
        try {
            String dbName = (String)JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName");
            if (dbName != null) {
                if (dbName.startsWith("DB2")) {
                    dbName = "DB2";
                }
                Iterator dbNameIter = this.rdbmsErrorCodes.keySet().iterator();
                while (dbNameIter.hasNext()) {
                    String checkDbName = (String)dbNameIter.next();
                    if (checkDbName == null || !checkDbName.startsWith("*") && !checkDbName.endsWith("*")) continue;
                    if (checkDbName.startsWith("*") && checkDbName.endsWith("*")) {
                        if (dbName.indexOf(checkDbName.substring(1, checkDbName.length() - 1)) < 0) continue;
                        dbName = checkDbName;
                        continue;
                    }
                    if (checkDbName.startsWith("*")) {
                        if (!dbName.endsWith(checkDbName.substring(1, checkDbName.length()))) continue;
                        dbName = checkDbName;
                        continue;
                    }
                    if (!checkDbName.endsWith("*") || !dbName.startsWith(checkDbName.substring(0, checkDbName.length() - 1))) continue;
                    dbName = checkDbName;
                }
                this.dataSourceProductNames.put(dataSource, dbName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Database product name cached for DataSource [" + dataSource + "]: name is '" + dbName + "'"));
                }
                return this.getErrorCodes(dbName);
            }
        }
        catch (MetaDataAccessException ex) {
            logger.warn((Object)"Error while extracting database product name - falling back to empty error codes", (Throwable)ex);
        }
        return new SQLErrorCodes();
    }

    public SQLErrorCodes getErrorCodes(String dbName) {
        Assert.notNull(dbName, "Database product name must not be null");
        SQLErrorCodes sec = (SQLErrorCodes)this.rdbmsErrorCodes.get(dbName);
        if (sec != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SQL error codes for '" + dbName + "' found"));
            }
            return sec;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SQL error codes for '" + dbName + "' not found"));
        }
        return new SQLErrorCodes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

