/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.uareu.jni;

import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.Reader;
import com.digitalpersona.uareu.UareUException;
import com.digitalpersona.uareu.dpfpdd.FidImpl;

public class Dpfpdd {
    public native int DpfpddInit();

    public native int DpfpddExit();

    public native int DpfpddQueryDevices(IntReference var1, Reader.Description[] var2, IntReference[] var3, IntReference[] var4);

    public native int DpfpddOpen(String var1, int var2, LongReference var3);

    public native int DpfpddClose(long var1);

    public native int DpfpddGetCapabilities(long var1, Reader.Capabilities var3);

    public native int DpfpddGetStatus(long var1, Reader.Status var3, IntReference var4);

    public native int DpfpddReset(long var1);

    public native int DpfpddCalibrate(long var1);

    public native int DpfpddCapture(long var1, int var3, int var4, int var5, int var6, int var7, IntReference var8, IntReference var9, FidImpl var10);

    public native int DpfpddCaptureCancel(long var1);

    public native int DpfpddStartStream(long var1);

    public native int DpfpddStopStream(long var1);

    public native int DpfpddGetStreamImage(long var1, int var3, int var4, int var5, int var6, IntReference var7, IntReference var8, FidImpl var9);

    public Dpfpdd() {
        System.loadLibrary("dpuareu_jni");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws UareUException {
        Dpfpdd dpfpdd = this;
        synchronized (dpfpdd) {
            int result = this.DpfpddInit();
            if (0 != result) {
                throw new UareUException(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() throws UareUException {
        Dpfpdd dpfpdd = this;
        synchronized (dpfpdd) {
            int result = this.DpfpddExit();
            if (0 != result) {
                throw new UareUException(result);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Reader.Description[] query_devices() throws UareUException {
        descriptions = new Reader.Description[]{};
        technologies = new IntReference[]{};
        modalities = new IntReference[]{};
        cnt = new IntReference(0);
        block0: while (true) {
            if (0 == (result = this.DpfpddQueryDevices(cnt, descriptions, technologies, modalities))) {
                for (i = 0; i < descriptions.length; ++i) {
                    descriptions[i].technology = Dpfpdd.toTechnology(technologies[i].value);
                    descriptions[i].modality = Dpfpdd.toModality(modalities[i].value);
                }
                return descriptions;
            }
            if (0 == result) continue;
            if (96075789 != result) {
                throw new UareUException(result);
            }
            descriptions = new Reader.Description[cnt.value];
            technologies = new IntReference[cnt.value];
            modalities = new IntReference[cnt.value];
            i = 0;
            while (true) {
                if (i < descriptions.length) ** break;
                continue block0;
                descriptions[i] = new Reader.Description();
                technologies[i] = new IntReference(0);
                modalities[i] = new IntReference(0);
                ++i;
            }
            break;
        }
    }

    public long open(String strReaderName, Reader.Priority prio) throws UareUException {
        LongReference hReader = new LongReference(0L);
        int result = this.DpfpddOpen(strReaderName, Dpfpdd.fromPriority(prio), hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
        return hReader.value;
    }

    public void close(long hReader) throws UareUException {
        int result = this.DpfpddClose(hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    public Reader.Capabilities get_capabilities(long hReader) throws UareUException {
        Reader.Capabilities caps = new Reader.Capabilities();
        int result = this.DpfpddGetCapabilities(hReader, caps);
        if (0 != result) {
            throw new UareUException(result);
        }
        return caps;
    }

    public Reader.Status get_status(long hReader) throws UareUException {
        Reader.Status status = new Reader.Status();
        IntReference IntStatus = new IntReference(0);
        int result = this.DpfpddGetStatus(hReader, status, IntStatus);
        if (0 != result) {
            throw new UareUException(result);
        }
        status.status = Dpfpdd.toStatus(IntStatus.value);
        return status;
    }

    public void reset(long hReader) throws UareUException {
        int result = this.DpfpddReset(hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    public void calibrate(long hReader) throws UareUException {
        int result = this.DpfpddCalibrate(hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    public Reader.CaptureResult capture(long hReader, int size_expected, Fid.Format img_format, Reader.ImageProcessing img_proc, int resolution, int timeout) throws UareUException {
        IntReference score = new IntReference(0);
        IntReference quality = new IntReference(0);
        FidImpl fid = new FidImpl(img_format, 1);
        int result = this.DpfpddCapture(hReader, size_expected, Dpfpdd.fromFormat(img_format), Dpfpdd.fromImageProcessing(img_proc), resolution, timeout, score, quality, fid);
        if (0 != result) {
            throw new UareUException(result);
        }
        Reader.CaptureResult cres = new Reader.CaptureResult();
        cres.score = score.value;
        cres.quality = Dpfpdd.toQuality(quality.value);
        if (null != fid.getData() && 0 != fid.getData().length) {
            cres.image = fid;
        }
        return cres;
    }

    public void capture_cancel(long hReader) throws UareUException {
        int result = this.DpfpddCaptureCancel(hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    public void start_stream(long hReader) throws UareUException {
        int result = this.DpfpddStartStream(hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    public void stop_stream(long hReader) throws UareUException {
        int result = this.DpfpddStopStream(hReader);
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    public Reader.CaptureResult get_stream_image(long hReader, int size_expected, Fid.Format img_format, Reader.ImageProcessing img_proc, int resolution) throws UareUException {
        IntReference score = new IntReference(0);
        IntReference quality = new IntReference(0);
        FidImpl fid = new FidImpl(img_format, 1);
        int result = this.DpfpddGetStreamImage(hReader, size_expected, Dpfpdd.fromFormat(img_format), Dpfpdd.fromImageProcessing(img_proc), resolution, score, quality, fid);
        if (0 != result) {
            throw new UareUException(result);
        }
        Reader.CaptureResult cres = new Reader.CaptureResult();
        cres.score = score.value;
        cres.quality = Dpfpdd.toQuality(quality.value);
        if (null != fid.getData() && 0 != fid.getData().length) {
            cres.image = fid;
        }
        return cres;
    }

    private static Reader.Technology toTechnology(int n) {
        switch (n) {
            case 0: {
                return Reader.Technology.HW_TECHNOLOGY_UNKNOWN;
            }
            case 1: {
                return Reader.Technology.HW_TECHNOLOGY_OPTICAL;
            }
            case 2: {
                return Reader.Technology.HW_TECHNOLOGY_CAPACITIVE;
            }
            case 3: {
                return Reader.Technology.HW_TECHNOLOGY_THERMAL;
            }
            case 4: {
                return Reader.Technology.HW_TECHNOLOGY_PRESSURE;
            }
        }
        return Reader.Technology.HW_TECHNOLOGY_UNKNOWN;
    }

    private static Reader.Modality toModality(int n) {
        switch (n) {
            case 0: {
                return Reader.Modality.HW_MODALITY_UNKNOWN;
            }
            case 1: {
                return Reader.Modality.HW_MODALITY_SWIPE;
            }
            case 2: {
                return Reader.Modality.HW_MODALITY_AREA;
            }
        }
        return Reader.Modality.HW_MODALITY_UNKNOWN;
    }

    private static Reader.ReaderStatus toStatus(int n) {
        switch (n) {
            case 0: {
                return Reader.ReaderStatus.READY;
            }
            case 1: {
                return Reader.ReaderStatus.BUSY;
            }
            case 2: {
                return Reader.ReaderStatus.NEED_CALIBRATION;
            }
            case 3: {
                return Reader.ReaderStatus.FAILURE;
            }
        }
        return Reader.ReaderStatus.FAILURE;
    }

    private static int fromFormat(Fid.Format fmt) {
        switch (fmt) {
            case ANSI_381_2004: {
                return 1770497;
            }
            case ISO_19794_4_2005: {
                return 0x1010007;
            }
        }
        return 0;
    }

    private static int fromImageProcessing(Reader.ImageProcessing proc) {
        switch (proc) {
            case IMG_PROC_DEFAULT: {
                return 0;
            }
            case IMG_PROC_PIV: {
                return 1;
            }
            case IMG_PROC_ENHANCED: {
                return 2;
            }
            case IMG_PROC_UNPROCESSED: {
                return 1382119241;
            }
        }
        return 0;
    }

    private static int fromPriority(Reader.Priority prio) {
        switch (prio) {
            case COOPERATIVE: {
                return 2;
            }
            case EXCLUSIVE: {
                return 4;
            }
        }
        return 2;
    }

    private static Reader.CaptureQuality toQuality(int n) {
        switch (n) {
            case 0: {
                return Reader.CaptureQuality.GOOD;
            }
            case 1: {
                return Reader.CaptureQuality.TIMED_OUT;
            }
            case 2: {
                return Reader.CaptureQuality.CANCELED;
            }
            case 4: {
                return Reader.CaptureQuality.NO_FINGER;
            }
            case 8: {
                return Reader.CaptureQuality.FAKE_FINGER;
            }
            case 16: {
                return Reader.CaptureQuality.FINGER_TOO_LEFT;
            }
            case 32: {
                return Reader.CaptureQuality.FINGER_TOO_RIGHT;
            }
            case 64: {
                return Reader.CaptureQuality.FINGER_TOO_HIGH;
            }
            case 128: {
                return Reader.CaptureQuality.FINGER_TOO_LOW;
            }
            case 256: {
                return Reader.CaptureQuality.FINGER_OFF_CENTER;
            }
            case 512: {
                return Reader.CaptureQuality.SCAN_SKEWED;
            }
            case 1024: {
                return Reader.CaptureQuality.SCAN_TOO_SHORT;
            }
            case 2048: {
                return Reader.CaptureQuality.SCAN_TOO_LONG;
            }
            case 4096: {
                return Reader.CaptureQuality.SCAN_TOO_SLOW;
            }
            case 8192: {
                return Reader.CaptureQuality.SCAN_TOO_FAST;
            }
            case 16384: {
                return Reader.CaptureQuality.SCAN_WRONG_DIRECTION;
            }
            case 32768: {
                return Reader.CaptureQuality.READER_DIRTY;
            }
        }
        return Reader.CaptureQuality.NO_FINGER;
    }

    private class LongReference {
        protected long value;

        protected LongReference(long n) {
            this.value = n;
        }
    }

    private class IntReference {
        protected int value;

        protected IntReference(int n) {
            this.value = n;
        }
    }
}

