/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPlatform;
import com.rameses.platform.interfaces.AppLoader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

class OSAppLoader {
    private AppLoader appLoader;
    private Map env;
    private URL[] urls;
    private AppLoader activeAppLoader;
    private ClassLoader activeClassLoader;

    public OSAppLoader(AppLoader appLoader, Map env, URL[] urls) {
        this.appLoader = appLoader;
        this.env = env;
        this.urls = urls;
    }

    public void load(OSPlatform platform) {
        try {
            ClassLoader newClassLoader = null;
            newClassLoader = this.urls != null ? new URLClassLoader(this.urls, OSManager.getOriginalClassLoader()) : OSManager.getOriginalClassLoader();
            String loaderName = (String)this.env.get("app.loader");
            if (loaderName == null || loaderName.trim().length() == 0) {
                throw new NullPointerException("app.loader must be provided in the ENV");
            }
            AppLoader newAppLoader = (AppLoader)newClassLoader.loadClass(loaderName).newInstance();
            HashMap newEnv = new HashMap();
            if (this.env != null) {
                newEnv.putAll(this.env);
            }
            newAppLoader.load(newClassLoader, newEnv, platform);
            this.activeAppLoader = newAppLoader;
            this.activeClassLoader = newClassLoader;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public void destroy() {
        if (this.activeAppLoader == null) {
            return;
        }
        this.activeAppLoader = null;
        this.activeClassLoader = null;
    }

    public ClassLoader getClassLoader() {
        if (this.activeClassLoader == null) {
            return OSManager.getOriginalClassLoader();
        }
        return this.activeClassLoader;
    }
}

