/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.ExplorerView;
import com.rameses.osiris3.platform.MainViewLayout;
import com.rameses.platform.interfaces.ContentPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class MainViewPanel
extends JPanel
implements MainViewLayout.Provider {
    private static final long serialVersionUID = 1L;
    private MainViewLayout layout = new MainViewLayout(this);
    private Rectangle viewRect;
    private Rectangle dividerRect;
    private Point targetPoint;
    private ExplorerView explorerView;

    public MainViewPanel() {
        super.setLayout(this.layout);
        this.explorerView = new ExplorerView();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainViewPanel.this.layout.propertyChange(evt);
            }
        });
    }

    @Override
    public LayoutManager getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public int getDividerSize() {
        return this.layout.getDividerSize();
    }

    public void setDividerSize(int dividerSize) {
        this.layout.setDividerSize(dividerSize);
    }

    public int getDividerLocation() {
        return this.layout.getDividerLocation();
    }

    public void setDividerLocation(int dividerLocation) {
        this.layout.setDividerLocation(dividerLocation);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.dividerRect != null && this.targetPoint != null) {
            Rectangle newRect = new Rectangle();
            newRect.x = this.dividerRect.x;
            newRect.y = this.dividerRect.y;
            newRect.width = this.dividerRect.width;
            newRect.height = this.dividerRect.height;
            newRect.x = this.dividerRect.x + this.targetPoint.x;
            Color oldColor = g.getColor();
            Color newColor = this.getBackground();
            newColor = newColor == null ? Color.DARK_GRAY : newColor.darker();
            Graphics gg = g.create();
            gg.setColor(newColor);
            gg.fillRect(newRect.x, newRect.y, newRect.width, newRect.height);
            gg.setColor(oldColor);
            this.dividerRect = null;
            this.targetPoint = null;
        }
    }

    @Override
    public void paintDividerHandle(Rectangle viewRect, Rectangle dividerRect, Point targetPoint) {
        this.viewRect = viewRect;
        this.dividerRect = dividerRect;
        this.targetPoint = targetPoint;
        this.repaint();
    }

    public Component getExplorer() {
        BorderLayout borderLayout = (BorderLayout)this.explorerView.getLayout();
        return borderLayout.getLayoutComponent("Center");
    }

    public void setExplorer(Component explorer, String title) {
        Component old = this.layout.getLayoutComponent("EXPLORER");
        if (old != null) {
            String newname = explorer == null ? null : explorer.getName();
            String oldname = old.getName();
            if (oldname != null && oldname.equals(newname)) {
                return;
            }
            if (newname != null && newname.equals(oldname)) {
                return;
            }
            this.remove(old);
        } else {
            this.layout.setLocationIndex(200);
        }
        this.explorerView.removeAll();
        if (explorer != null) {
            this.explorerView.setName(explorer.getName());
            this.explorerView.attachHeader();
            this.explorerView.setTitle(title);
            this.explorerView.add(explorer);
            this.add((Component)this.explorerView, "EXPLORER");
        }
    }

    public void setContent(Component content) {
        Component old = this.layout.getLayoutComponent("CONTENT");
        if (old != null) {
            this.remove(old);
        }
        this.add(content, "CONTENT");
    }

    public void updateCanvas() {
        this.revalidate();
        this.repaint();
    }

    public boolean isExplorerInFocus() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        return this.explorerView.isAncestorOf(focusOwner);
    }

    public void showExplorerInfo() {
        Component comp = this.getExplorer();
        if (!(comp instanceof ContentPane)) {
            return;
        }
        ContentPane cp = (ContentPane)((Object)comp);
        ContentPane.View vw = cp.getView();
        if (vw != null) {
            vw.showInfo();
        }
    }

    private class PropertyChangeSupport
    implements PropertyChangeListener {
        private PropertyChangeSupport() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("toggleLeftView".equals(name)) {
                MainViewPanel.this.layout.propertyChange(evt);
            }
        }
    }
}

