/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.SubWindowImpl;
import com.rameses.osiris3.platform.WindowContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

class ExplorerView
extends JPanel
implements WindowContainer {
    private HeaderRenderer header;

    public ExplorerView() {
        super.setLayout(new BorderLayout());
        Border border = BorderFactory.createLineBorder(new Color(150, 150, 150), 1);
        super.setBorder(border);
        this.header = new HeaderRenderer();
        this.header.setText(" ");
        this.add((Component)this.header, "North");
    }

    void setTitle(String title) {
        this.header.setText(title == null ? " " : title);
    }

    void attachHeader() {
        this.remove(this.header);
        this.add((Component)this.header, "North");
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.removeAll();
        super.addImpl(this.header, "North", -1);
        if (!(comp instanceof HeaderRenderer) && comp instanceof SubWindowImpl) {
            SubWindowImpl swin = (SubWindowImpl)comp;
            this.setTitle(swin.getTitle());
            super.addImpl(comp, "Center", -1);
            OSViewImpl osv = new OSViewImpl(comp);
            osv.setSubWindowImpl(swin);
            OSManager.getInstance().registerView(swin.getId(), osv);
        }
    }

    private Color brighter(Color c, int value) {
        if (value < 0) {
            return c;
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), new float[3]);
        int h = (int)(hsb[0] * 360.0f);
        int s = (int)(hsb[1] * 100.0f);
        int b = (int)(hsb[2] * 100.0f);
        int rm = 0;
        if ((b += value) > 100) {
            rm = b - 100;
            b = 100;
        }
        if ((s -= rm) < 0) {
            s = 0;
        }
        int rgb = Color.HSBtoRGB((float)h / 360.0f, (float)s / 100.0f, (float)b / 100.0f);
        return new Color(rgb);
    }

    private class HeaderBorder
    extends AbstractBorder {
        private boolean hideTop = true;
        private boolean hideLeft = false;
        private boolean hideBottom = false;
        private boolean hideRight = false;

        public HeaderBorder() {
        }

        public HeaderBorder(boolean hideTop, boolean hideLeft, boolean hideBottom, boolean hideRight) {
            this.hideTop = hideTop;
            this.hideLeft = hideLeft;
            this.hideBottom = hideBottom;
            this.hideRight = hideRight;
        }

        public void setHideTop(boolean hideTop) {
            this.hideTop = hideTop;
        }

        public void setHideLeft(boolean hideLeft) {
            this.hideLeft = hideLeft;
        }

        public void setHideBottom(boolean hideBottom) {
            this.hideBottom = hideBottom;
        }

        public void setHideRight(boolean hideRight) {
            this.hideRight = hideRight;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.bottom = 5;
            insets.top = 5;
            insets.right = 5;
            insets.left = 5;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            if (!this.hideTop) {
                g.drawLine(0, 0, w, 0);
            }
            g.setColor(this.getHighlightColor(c));
            if (!this.hideLeft) {
                g.drawLine(0, 2, 0, h - 5);
            }
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            if (!this.hideBottom) {
                g.drawLine(0, h - 2, w, h - 2);
            }
            g.setColor(this.getShadowColor(c));
            if (!this.hideRight) {
                g.drawLine(w - 1, 2, w - 1, h - 5);
            }
            g.setColor(oldColor);
        }

        protected Color getHighlightColor(Component c) {
            return c.getBackground().brighter();
        }

        protected Color getShadowColor(Component c) {
            return c.getBackground().darker();
        }
    }

    private class HeaderRenderer
    extends JLabel {
        ExplorerView root;
        private HeaderBorder border;

        public HeaderRenderer() {
            this.root = ExplorerView.this;
            this.border = new HeaderBorder();
            this.setBorder(this.border);
            this.setBackground(SystemColor.control);
        }

        protected Color getHighlightColor() {
            return this.getBackground().brighter();
        }

        protected Color getShadowColor() {
            return this.getBackground().darker();
        }

        @Override
        public void setFont(Font font) {
            if (font == null) {
                super.setFont(font);
                return;
            }
            HashMap<TextAttribute, Float> attrs = new HashMap<TextAttribute, Float>();
            attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            Font newFont = font.deriveFont(attrs);
            super.setFont(newFont);
        }

        @Override
        public void paint(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            Color oldColor = g.getColor();
            Color shadow = this.getShadowColor();
            Color bg = this.root.brighter(shadow, 30);
            Graphics2D g2 = (Graphics2D)g.create();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, bg, 0.0f, h / 2, this.root.brighter(shadow, 25));
            g2.setPaint(gp);
            g2.fillRect(0, 0, w, h);
            g2.setPaint(null);
            g2.setColor(this.root.brighter(shadow, 22));
            g2.fillRoundRect(0, h / 2, w, h, 5, 0);
            g2.dispose();
            g.setColor(oldColor);
            super.paint(g);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class OSViewImpl
    implements OSView {
        ExplorerView root;
        Component view;
        SubWindowImpl subWindow;

        OSViewImpl(Component view) {
            this.root = ExplorerView.this;
            this.view = view;
        }

        void setSubWindowImpl(SubWindowImpl subWindow) {
            this.subWindow = subWindow;
            if (subWindow != null) {
                subWindow.setView(this);
            }
        }

        @Override
        public WindowContainer getWindowContainer() {
            return this.root;
        }

        @Override
        public String getId() {
            return this.view.getName();
        }

        @Override
        public String getType() {
            return "tab";
        }

        @Override
        public void requestFocus() {
            if (this.root.isVisible()) {
                return;
            }
            this.root.setVisible(true);
            this.root.getParent().firePropertyChange("toggleLeftView", 0L, 1L);
            if (this.subWindow != null) {
                this.subWindow.activate();
            }
        }

        @Override
        public void closeView() {
            if (this.subWindow == null) {
                this.root.remove(this.view);
            } else {
                this.subWindow.close();
            }
        }
    }
}

